// Checker to be used by evaluator.
//
// Usage: [checker] [input] [official_output] [contestant_output]
//
// Score (real between 0.0 and 1.0) written on stdout.
// Textual description of the result written on stderr.

#include <algorithm>
#include <cassert>
#include <cstdlib>
#include <cstring>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <set>
#include <map>

using namespace std;

typedef pair<char, int> P;

const string WRONG_OUTPUT_FORMAT = "Krivo formatiran izlaz.";
const string TEST_DATA_ERROR = "Greska u sluzbenom ulazu ili izlazu.";
const string WRONG = "Netocno.";
const string CORRECT = "Tocno.";

const int DAYS[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

// official input
int total;
int n_dates;
vector<int> start_day;

// official output

// contestants data
vector<int> end_day;

void finish(double p, const string& m) {
  cout << p << endl;
  cerr << m << endl;
  exit(0);
}

int is_date(string s) {
  if ((int)s.size() != 6)
    return 0;
  if (!isdigit(s[0]) || !isdigit(s[1]) || !isdigit(s[3]) || !isdigit(s[4]))
    return 0;
  if (s[2] != '.' || s[5] != '.')
    return 0;
  int d = (s[0]-'0')*10 + s[1]-'0';
  int m = (s[3]-'0')*10 + s[4]-'0';
  if (m < 1 || m > 12)
    return 0;
  if (d < 1 || d > DAYS[m-1])
    return 0;
  return 1;
}

int to_day(string s) {
  int d = (s[0]-'0')*10 + s[1]-'0';
  int m = (s[3]-'0')*10 + s[4]-'0';
  int sol = 0;
  for (int i=0; i<m-1; i++)
    sol += DAYS[i];
  return sol+d;
}

void test() {
  assert(is_date("01.01."));
  assert(is_date("31.01."));
  assert(is_date("28.02."));
  assert(is_date("01.03."));
  assert(is_date("31.12."));
  assert(is_date("30.11."));
  assert(!is_date("01.00."));
  assert(!is_date("00.01."));
  assert(!is_date("29.02."));
  assert(!is_date("31.04."));
  assert(!is_date("31.11."));
  assert(!is_date("01.13."));
  assert(!is_date("1.1."));
  assert(!is_date("01.01"));
  assert(!is_date("01|01|"));
  assert(!is_date("01.02. "));
  assert(to_day("01.01.") == 1);
  assert(to_day("31.01.") == 31);
  assert(to_day("01.02.") == 32);
  assert(to_day("01.03.") == 31+28+1);
  assert(to_day("31.12.") == 365);
}

int check_solution() {
  int calculated = 0;
  for (int i=0; i<n_dates; i++) {
    if (end_day[i] < start_day[i]) {
      return 0;
    }
    calculated += 100*(end_day[i]-start_day[i]+1);
  }
  if (calculated != total) {
    return 0;
  }
  return 1;
}

int main(int argc, char *argv[])
{
  // test();
  assert(argc == 4);

  ifstream fin(argv[1]);
  ifstream foff(argv[2]);
  ifstream fout(argv[3]);

  assert(!fin.fail() && !fout.fail());
  
  // Read official input
  if (!(fin >> total)) {
    finish(0, TEST_DATA_ERROR);
  }

  if (!(fin >> n_dates)) {
    finish(0, TEST_DATA_ERROR);
  }

  start_day = vector<int>();
  for (int i=0; i<n_dates; i++) {
    string temp;
    if (!(fin >> temp)) {
      finish(0, TEST_DATA_ERROR);
    }
    if (!is_date(temp)) {
      finish(0, TEST_DATA_ERROR);
    }
    start_day.push_back(to_day(temp));
  }

  // Read official output

  // nothing to do

  // Read contestant output
  end_day = vector<int>();
  for (int i=0; i<n_dates; i++) {
    string temp;
    if (!(fout >> temp)) {
      finish(0, WRONG_OUTPUT_FORMAT);
    }
    if (!is_date(temp)) {
      finish(0, WRONG_OUTPUT_FORMAT);
    }
    end_day.push_back(to_day(temp));
  }

  // Check
  if (!check_solution()) {
    finish(0, WRONG);
  }

  finish(1, CORRECT);
  return 0;
}
